﻿from Qt import QtCore, QtWidgets
from wizart import maya_qtutils
import pymel.core as pm

class FaceCamWindow(QtWidgets.QWidget):
    camera_tfm = None
    def __init__(self, parent):
        super(FaceCamWindow, self).__init__(parent)
        self.setWindowTitle("Face Camera")
        self.setObjectName("CefPickerFaceCamWindow")
        #self.setStyleSheet("border: 1px black")
        self.setWindowFlags(QtCore.Qt.Window)
        self.setLayout(QtWidgets.QVBoxLayout())
        self.layout().setObjectName("CefPickerFaceCamWindowLayout")
        self.layout().setContentsMargins(0, 0, 0, 0)
        self.model_panel = None
        self.init_model_panel()

    def init_model_panel(self):
        if self.model_panel == None or pm.modelPanel(self.model_panel, exists = True) is False:
            lt_mayaName = maya_qtutils.toMayaObject(self.layout())
            pm.setParent(lt_mayaName)
            self.model_panel = pm.modelPanel(menuBarVisible=False)
            modelEditor = pm.modelPanel(self.model_panel, q = True, modelEditor = True)
            pm.modelEditor(modelEditor, e = True, viewSelected = True)
            pm.modelEditor(modelEditor, e = True, hud = False, dtx = True, da="smoothShaded", grid = False)

    def change_asset(self, asset_namespace, face_control_list):
        self.init_model_panel()
        camera_name = "%s:picker_face_cam" % asset_namespace
        if pm.objExists(camera_name):
            geometry_group_name = asset_namespace + ":" + "geometry"
            ignore_face_controls = ["R_eye_offset_control", "L_eye_offset_control", "M_eye_ik_control", "M_eye_fk_control"]
            ignore_face_controls = [(asset_namespace + ":" + ctrl) for ctrl in ignore_face_controls]
            sel = pm.ls(sl = True)
            filtered_face_controls = [ctrl for ctrl in face_control_list if ctrl not in ignore_face_controls]
            existing_face_controls = [ctrl for ctrl in filtered_face_controls if pm.objExists(ctrl)]
            pm.select(existing_face_controls, r = True)
            pm.select(geometry_group_name, add = True)
            modelEditor = pm.modelPanel(self.model_panel, q = True, modelEditor = True)
            pm.modelPanel(self.model_panel, e = True, camera = camera_name )
            pm.modelEditor(modelEditor, e = True, setSelected = True)
            pm.select( sel, r = True)
