﻿
__cef_picker_initialized__ = False


import os
if __cef_picker_initialized__ is False:
    os.environ['CEF_PICKER_INTERNAL'] = os.path.join(os.path.dirname(__file__), "internal_data")
    import wizart.cef
    wizart.cef.init()
    __cef_picker_initialized__ = True

from wizart import maya_qtutils

from Qt import QtWidgets, QtCore, QtGui
import pymel.core as pm
from functools import partial
from . import picker

def main():
    main = picker.PickerWindow(maya_qtutils.getMayaWindow(QtWidgets.QWidget))

    options_start_width = pm.optionVar.get("wizart_picker_options_start_win_width", 300)
    options_start_height = pm.optionVar.get("wizart_picker_options_start_win_height", 320)
    options_start_x = pm.optionVar.get("wizart_picker_options_start_pos_x")
    options_start_y = pm.optionVar.get("wizart_picker_options_start_pos_y")
    main.resize(options_start_width, options_start_height)
    if options_start_x and options_start_y:
        main.move(options_start_x, options_start_y)

    main.show()
    return main


def show_picker_for_node(node_name):
    last_obj = pm.PyNode(node_name)
    asset_namespace = last_obj.namespace()[:-1]
    pm.select(last_obj, r = True)
    found_tab = False
    for window in picker.PickerWindow.get_instances():
        current_idx = window.tab_widget.currentIndex()
        for idx in range(window.tab_widget.count()):
            widget = window.tab_widget.widget(idx)
            if asset_namespace == widget.asset_info.get("namespace"):
                if idx != current_idx:
                    window.tab_widget.setCurrentIndex(idx)
                found_tab = True
                break
    if not found_tab:
        ref = last_obj.referenceFile()
        if ref:
            asset_info = assets_utils.get_asset_info_from_ref(ref)
            if asset_info:
                windows = [x for x in picker.PickerWindow.get_instances() ]
                if len(windows) > 0:
                    window = windows[0]
                else:
                    window = main()
                tab_idx = window.add_tab(asset_info)
                window.tab_widget.setCurrentIndex(tab_idx)
