"""
import wizart.cef
wizart.cef.init()
import wizart.cef.widgets
from Qt import QtCore
widget = wizart.cef.widgets.CefWidget()
widget.setWindowFlags(QtCore.Qt.Window)
widget.embed_browser("https://prodtrack.wizartanimation.com/projects")
widget.show()
widget.browser.Reload()
widget.show_dev_tools()

"""

from Qt import QtWidgets, QtCore
import wizart.cef as cef

class CefWidget(QtWidgets.QWidget):
    def __init__(self, parent=None):
        super(CefWidget, self).__init__(parent)
        self.browser = None
    
    def embed_browser(self, url):
        if self.browser:
            self.destroy_browser()
        self.browser = cef.CreateBrowserSync(int(self.winId()), url)
    
    def destroy_browser(self):
        if self.browser:
            self.browser.Close()
            self.browser = None    
    
    def show_dev_tools(self):
        if self.browser:
            self.browser.ShowDevTools(int(self.winId()))
    
    def resizeEvent(self, event):
        size = event.size()
        width = size.width()
        height = size.height()
        if self.browser:
            self.browser.Resize(0, 0, width, height)