__cef_initialized__ = False
import os, sys
if __cef_initialized__ is False:
    cef_shared_lib_directory = os.path.join(os.path.dirname(__file__), "bin")
    if sys.platform == "win32" and sys.version_info[0] >= 3 and sys.version_info[1] >= 8:
        os.add_dll_directory(cef_shared_lib_directory)
    else:
        os.environ["PATH"] += ";" +  cef_shared_lib_directory

CEF_SINGLETON = None

from . _wizart_cef import *

from Qt import QtWidgets, QtCore

import sys
WIZART_CEF_HOST_IS_MAYA = False
if sys.executable == "maya.exe":
    WIZART_CEF_HOST_IS_MAYA = True

def init():
    """
    Note that Cef Initialize must be called once per maya process life
    """
    global __cef_initialized__
    if __cef_initialized__ is False:
        __cef_initialized__ = True
        cef_settings = {}
        cef_settings["resources_dir_path"] = os.path.join(os.path.dirname(__file__),"resources")
        cef_settings["locales_dir_path"] =  os.path.join(os.path.dirname(__file__),"resources", "locales")
        cef_settings["browser_subprocess_path"] =  os.path.join(os.path.dirname(__file__), "bin", "wizart_cef.exe")
        cef_settings["cache_path"] =  os.path.join(os.environ["USERPROFILE"], ".wizart_cef")
        Initialize(cef_settings)

        if WIZART_CEF_HOST_IS_MAYA:
            pm.api.MEventMessage.addEventCallback("quitApplication",lambda *args:shutdown())
        QtWidgets.QApplication.instance().aboutToQuit.connect(shutdown)


def shutdown():
    print('cef_shutdown')
    Shutdown()