
var picker_util =
{
    svg_doc : null,

    popupmenu: function(jquery_event, selector, target_center, callback_data, callback, evt)
    {
            $(this.svg_doc).find(selector)[jquery_event](callback_data, function(evt)
            {
                evt.preventDefault();
                var _callback_data = evt.data.callback_data;
                if( target_center == true)
                {
                  var bound_rect = evt.target.parentNode.getBoundingClientRect();
                  var posX = (bound_rect.left + bound_rect.width / 2) | 0;
                  var posY = (bound_rect.top + bound_rect.height / 2) | 0
                  callback(evt, _callback_data, posX, posY);
                }
                else
                {
                    var posX = evt.clientX;
                    var posY = evt.clientY;
                    callback(evt, _callback_data, posX, posY);
                }
            });
    },
    get_control_name: function (element)
    {
        if(element.hasAttribute("maya_node"))
        {
            return element.getAttribute("maya_node");
        }
        else
        {
            return element.id;
        }
    },
    find_control: function(name)
    {
        result = [];

        var found_by_id = this.svg_doc.getElementById(name);
        var selector = this.svg_doc.querySelectorAll("[maya_node=" + name + "]");
        if (selector.length > 0)
        {
            for(var i = 0; i < selector.length; i++)
            {
                result.push(selector[i]);
            }
        }
        else if (this.svg_doc.getElementById(name) != null)
        {
            result.push(found_by_id);
        }

        return result;
    },
    contextmenu: function(selector, target_center, callback_data, callback, evt)
    {
          this.popupmenu('contextmenu', selector, target_center, callback_data, callback, evt );
    },
    enable_control: function(control_name)
    {
        var controls = this.find_control(control_name);
        for (var i = 0; i < controls.length; i++)
        {
            var control = controls[i];
            if (control != null && control.classList.contains("disabled")) {
                control.classList.remove("disabled");
            }
        }
    },
    disable_control: function(control_name)
    {
        var controls = this.find_control(control_name);
        for (var i = 0; i < controls.length; i++)
        {
            var control = controls[i];
            if (control != null && !(control.classList.contains("disabled"))) {
                control.classList.add("disabled");

            }

        }

      
    },
    hide_control: function(control_name)
    {
        var controls = this.find_control(control_name);
        for (var i = 0; i < controls.length; i++)
        {
            var control = controls[i];
            if (control != null && !(control.classList.contains("hidden"))) {
                control.classList.add("hidden");
            }
        }
    },
    show_control: function(control_name)
    {
        var controls = this.find_control(control_name);
        for (var i = 0; i < controls.length; i++)
        {

            var control = controls[i];
            if (control != null && control.classList.contains("hidden")) {
                control.classList.remove("hidden");
            }
        }
     
    },

    higlight_selection: function(control_name)
    {
        var controls = this.find_control(control_name);
        for (var i = 0; i < controls.length; i++)
        {
            var control = controls[i];
            if (control != null && control.classList.contains("selected") == false)
            {
                control.classList.add("selected");
            }
        }
         
    },
    remove_selection: function(control_name)
    {
        var controls = this.find_control(control_name);
        for (var i = 0; i < controls.length; i++)
        {
            var control = controls[i];
            if (control != null && control.classList.contains("selected") == true)
            {
                control.classList.remove("selected");
            }
          
        }
   
    },
    clear_selection: function(control_name)
    {
        var selected = this.svg_doc.querySelectorAll(".selected");
        if(selected !=null)
        {
          [].forEach.call(selected, function(control, i, selected)
          {
              control.classList.remove("selected");
          });
        }
    },
    install_ikfk_switch_btn_callbacks: function(ikfk_switch_pairs)
    {

      for (var i = 0; i < ikfk_switch_pairs.length; i++)
      {
          $(this.svg_doc).find("#" + ikfk_switch_pairs[i].ctrl).click({ maya_ctrl: ikfk_switch_pairs[i].maya_ctrl, type: ikfk_switch_pairs[i].type },
          function (evt)
          {
              if(PanZoom.is_active == false)
              {
                var maya_ctrl = maya.add_asset_namespace(evt.data.maya_ctrl);
                  maya.python("import wizart.anim_utils as anim_utils; anim_utils.kinematicSwitchMulti('" + maya_ctrl + "')");
              }
          });
      }
    },
    install_rig_ctx_menu: function(ctrl_name)
    {
        picker_util.contextmenu("#" + ctrl_name, true, { maya_ctrl: ctrl_name},
            function(evt, callback_data, posX, posY) {
              if( PanZoom.is_active == false)
              {
                var maya_ctrl = maya.add_asset_namespace(evt.data.maya_ctrl);
                maya.call_rig_contextmenu(posX, posY, maya_ctrl);
               }
            }
         );
    }
    ,
    install_common_context_menu: function()
    {
            var that = this;
            $(this.svg_doc).find(".control").each
            (
                function(index, element)
                {
                    var control_name = picker_util.get_control_name(element);
                    that.install_rig_ctx_menu(control_name);
                }
            );
            
    },
    reset_selected_controls: function()
    {
      maya.mel("undoInfo -openChunk");
      for(var i = 0; i < PanZoom.selection_names.length; i++)
      {
          var control_name = maya.add_asset_namespace(PanZoom.selection_names[i]);
          maya.python("import wizart.anim_utils as anim_utils;anim_utils.resetControl(\"" +control_name+  ":\")");
      }

      maya.mel("undoInfo -closeChunk");
    },

    get_layer_controls: function(layer_name)
    {
        var control_list = [];
      $(this.svg_doc).find("#" + layer_name).find(".control").each(
        function(index, element)
        {
            control_list.push( maya.add_asset_namespace(  picker_util.get_control_name(element) )  );
        }
      );

      return control_list;
    },
    get_all_controls: function()
    {
        var control_list = [];
        $(this.svg_doc).find(".control").each
        (
            function(index, element)
            {
                var control_name = picker_util.get_control_name(element);
                control_list.push(maya.add_asset_namespace(control_name));
            }
        );

        return control_list;
    },
    pick_layer_controls: function(layer_name)
    {
      var control_list = this.get_layer_controls(layer_name);
      if( control_list.length > 0)
      {
        cmd = "select -r";
        for(var i = 0; i < control_list.length; i++)
        {
            cmd += " " + control_list[i];
        }
        maya.mel(cmd);
      }
    },
    pick_all_controls: function ()
    {

        cmd = "select -r";
        cmd += " `ls \"" + window.asset_namespace + ":*_control\"`"
        maya.mel(cmd);
    },
    select_cmd_from_event: function(evt)
    {
        cmd = "select -tgl";

        if (evt.shiftKey && evt.ctrlKey) {
            cmd = "select -add";
        }
        else if (evt.ctrlKey) {
            cmd = "select -deselect";
        }
        else if (!evt.shiftKey) {
            cmd = "select -r";
        }

        return cmd;
    },

    open_face_cam: function()
    {
      var control_list = this.get_layer_controls("face");
      maya.call_open_face_cam(control_list);

    },
    make_enum_btn: function (element_name, attr_name, variants)
    {
      maya.track_attributes([maya.add_asset_namespace(attr_name)]);
      var that = this;
      maya.add_attribute_change_callback(function(attribute_name, attribute_value)
      {
        attribute_name = maya.remove_namespace(attribute_name);
        if(attribute_name == attr_name)
        {
          var el = that.svg_doc.getElementById(element_name);
          $(el).find(".btn-dynamic-text").each(
            function(index, element)
            {
                element.innerHTML = variants[attribute_value].toUpperCase();
            }
          );
        }
      }
      );
      this.popupmenu('click',"#" + element_name, true, { maya_attr: attr_name,variants: variants},
          function(evt, callback_data, posX, posY) {
            if( PanZoom.is_active == false)
            {
              var maya_attr = maya.add_asset_namespace(evt.data.maya_attr);
              var menu_list = [];
              for(var i = 0; i < evt.data.variants.length; i++)
              {
                js_cmd = "maya.mel('setAttr " + maya_attr + " " + String(i) + "');";
                menu_list.push([evt.data.variants[i], js_cmd]  );
              }

              maya.call_contextmenu(posX, posY, menu_list);
            }
          }
       );
    },
    make_bool_btn: function (element_name, attr_name, callback)
    {
      maya.track_attributes([maya.add_asset_namespace(attr_name)]);
      var that = this;
      maya.add_attribute_change_callback(function(attribute_name, attribute_value)
      {
        attribute_name = maya.remove_namespace(attribute_name);
        if(attribute_name == attr_name)
        {
          var el = that.svg_doc.getElementById(element_name);
          var state_str = attribute_value == 0 ? "off" : "on";
          el.setAttribute("state", state_str);

          if (state_str == "on")
          {
            el.classList.add("active");
          }
          else if (state_str == "off")
          {
            el.classList.remove("active");
          }
          if(callback != null)
          {
              callback(state_str);
          }
          $(el).find(".btn-dynamic-text").each(
            function(index, element)
            {
                element.innerHTML = state_str.toUpperCase();

            }
          );
        }
      }
      );
      $(this.svg_doc).find("#" + element_name).click(
        function()
        {
            var el = that.svg_doc.getElementById(element_name);
            var state_str = el.getAttribute("state");
            var new_state = state_str == "on" ? "off": "on";

            var search_name = maya.add_asset_namespace(attr_name);
            maya.mel("setAttr " + search_name + " " + new_state);
        }
      );
    },
    update_avatar_vis: function()
    {
        avatar = document.getElementById("avatar");
        if( window.options_hide_avatar == true)
        {
            avatar.classList.add("hidden");
        }
        else
        {
            avatar.classList.remove("hidden");
        }
    },
    install_top_panel_callbacks: function()
    {
        top_panel = document.getElementById("top_panel")
        if (top_panel != null)
        {
                top_panel = top_panel.getSVGDocument();
                $(top_panel).find("#btn_focus_face").click(function (evt) {
                    if (PanZoom.is_active == false) {
                        PanZoom.focus_element_name = "face";
                        PanZoom.resize_fit();
                        $(top_panel).find("#btn_focus_all")[0].classList.remove("active");
                        $(top_panel).find("#btn_focus_body")[0].classList.remove("active");
                        $(top_panel).find("#btn_focus_face")[0].classList.add("active");
                    }
                });

                $(top_panel).find("#btn_focus_body").click(function (evt) {
                    if (PanZoom.is_active == false) {
                        PanZoom.focus_element_name = "body";
                        PanZoom.resize_fit();

                        $(top_panel).find("#btn_focus_all")[0].classList.remove("active");
                        $(top_panel).find("#btn_focus_body")[0].classList.add("active");
                        $(top_panel).find("#btn_focus_face")[0].classList.remove("active");
                    }
                });

                $(top_panel).find("#btn_focus_all").click(function (evt) {
                    if (PanZoom.is_active == false) {
                        PanZoom.focus_element_name = null;
                        PanZoom.resize_fit();
                        $(top_panel).find("#btn_focus_all")[0].classList.add("active");
                        $(top_panel).find("#btn_focus_body")[0].classList.remove("active");
                        $(top_panel).find("#btn_focus_face")[0].classList.remove("active");
                    }
                });

                if (window.options_start_focus == "all") {
                    $(top_panel).find("#btn_focus_all")[0].classList.add("active");
                    PanZoom.focus_element_name = null;
                    PanZoom.resize_fit();
                }
                else if (window.options_start_focus == "body") {
                    $(top_panel).find("#btn_focus_body")[0].classList.add("active");
                    PanZoom.focus_element_name = "body";
                    PanZoom.resize_fit();
                }
                else if (window.options_start_focus == "face") {
                    $(top_panel).find("#btn_focus_face")[0].classList.add("active");
                    PanZoom.focus_element_name = "face";
                    PanZoom.resize_fit();
                }
                maya.track_attributes([maya.add_asset_namespace("character.visibility"), maya.add_asset_namespace("controls.visibility"),
                    maya.add_asset_namespace("M_head_options_control.face_controls"), maya.add_asset_namespace("M_head_options_control.minors") ]);

                maya.add_attribute_change_callback(function (attribute_name, attribute_value) {
                    attribute_name = maya.remove_namespace(attribute_name);
                    if (attribute_name == "character.visibility") 
                    {
                        var el = $(top_panel).find("#btn_vis_all")[0];
                        var state_str = attribute_value == 0 ? "off" : "on";
                        el.setAttribute("state", state_str);

                        if (state_str == "on") {
                            el.classList.add("active");
                        }
                        else if (state_str == "off") {
                            el.classList.remove("active");
                        }
                    }
                    else if (attribute_name == "controls.visibility")
                    {
                        var el = $(top_panel).find("#btn_vis_all_controls")[0];
                        var state_str = attribute_value == 0 ? "off" : "on";
                        el.setAttribute("state", state_str);

                        if (state_str == "on") {
                            el.classList.add("active");
                        }
                        else if (state_str == "off") {
                            el.classList.remove("active");
                        }
                    }


                    else if (attribute_name == "M_head_options_control.face_controls")
                    {
                        var el = $(top_panel).find("#btn_vis_face_controls")[0];
                        var state_str = attribute_value == 0 ? "off" : "on";
                        el.setAttribute("state", state_str);

                        if (state_str == "on") {
                            el.classList.add("active");
                        }
                        else if (state_str == "off") {
                            el.classList.remove("active");
                        }
                    }

                    else if (attribute_name == "M_head_options_control.minors")
                    {
                        var el = $(top_panel).find("#btn_vis_face_minors")[0];
                        var state_str = attribute_value == 0 ? "off" : "on";
                        el.setAttribute("state", state_str);

                        if (state_str == "on") {
                            el.classList.add("active");
                        }
                        else if (state_str == "off") {
                            el.classList.remove("active");
                        }
                    }
                }
                );
                //Char Visibility
                $(top_panel).find("#btn_vis_all").click(function (evt) {
                    var el = $(top_panel).find("#btn_vis_all")[0];
                    var state_str = el.getAttribute("state");
                    state_str = state_str == "on" ? "off" : "on";
                    maya.mel("setAttr " + window.asset_namespace + ":character.visibility " + state_str);
                });

                $(top_panel).find("#btn_vis_all_controls").click(function (evt) {
                    var el = $(top_panel).find("#btn_vis_all_controls")[0];
                    var state_str = el.getAttribute("state");
                    state_str = state_str == "on" ? "off" : "on";
                    maya.mel("setAttr " + window.asset_namespace + ":controls.visibility " + state_str);
                });

                $(top_panel).find("#btn_vis_face_controls").click(function (evt) {
                    var el = $(top_panel).find("#btn_vis_face_controls")[0];
                    var state_str = el.getAttribute("state");
                    state_str = state_str == "on" ? "off" : "on";
                    maya.mel("setAttr " + window.asset_namespace + ":M_head_options_control.face_controls " + state_str);
                });


                $(top_panel).find("#btn_vis_face_minors").click(function (evt) {
                    var el = $(top_panel).find("#btn_vis_face_minors")[0];
                    var state_str = el.getAttribute("state");
                    state_str = state_str == "on" ? "off" : "on";
                    maya.mel("setAttr " + window.asset_namespace + ":M_head_options_control.minors " + state_str);
                });

           
        }
    },

    install_avatar_panel_callbacks: function()
    {
        avatar_panel = document.getElementById("avatar_panel");
        if (avatar_panel != null) {
            avatar_panel = avatar_panel.getSVGDocument();
            $(avatar_panel).find("#btn_pick_body").click(function (evt) {
                cmd = picker_util.select_cmd_from_event(evt);
                var control_list = picker_util.get_layer_controls("body");

                if (control_list.length > 0) {
                    for (var i = 0; i < control_list.length; i++) {
                        cmd += " " + control_list[i];
                    }
                    maya.mel(cmd);
                }

            });

            $(avatar_panel).find("#btn_pick_face").click(function (evt) {
                cmd = picker_util.select_cmd_from_event(evt);
                var control_list = picker_util.get_layer_controls("face");

                if (control_list.length > 0) {
                    for (var i = 0; i < control_list.length; i++) {
                        cmd += " " + control_list[i];
                    }
                    maya.mel(cmd);
                }
            });

            $(avatar_panel).find("#btn_pick_all").click(function (evt) {
                cmd = picker_util.select_cmd_from_event(evt);

                cmd += " `ls \"" + window.asset_namespace + ":*_control\"`"
                maya.mel(cmd);
            });
        }

      

    },
    install_common_callbacks: function()
    {

          this.update_avatar_vis();
          maya.node_selected = function(control_name)
          {
            var namespace = maya.extract_namespace(control_name);
            if(namespace == window.asset_namespace)
            {
              picker_util.higlight_selection(maya.remove_namespace(control_name) );
              PanZoom.selection_names.push(maya.remove_namespace(control_name) );
            }

          };
          maya.update_selection = function (new_sel)
          {
              var new_sel_filtered = []
              for (var i = 0; i < new_sel.length; i++)
              {
                  var namespace = maya.extract_namespace(new_sel[i]);
                  if (namespace == window.asset_namespace)
                  {
                      new_sel_filtered.push(maya.remove_namespace(new_sel[i]));
                  }
              }



              var add_selection = new_sel_filtered.filter(function (el) { return PanZoom.selection_names.indexOf(el) < 0 });
              var remove_selection = PanZoom.selection_names.filter(function (el) { return new_sel_filtered.indexOf(el) < 0 });

              for (var i = 0; i < add_selection.length; i++)
              {
                  picker_util.higlight_selection(add_selection[i]);

                  PanZoom.selection_names.push(add_selection[i]);
              }

              for (var i = 0; i < remove_selection.length; i++)
              {
                  picker_util.remove_selection(remove_selection[i]);

                  PanZoom.selection_names.splice(PanZoom.selection_names.indexOf(remove_selection[i]), 1 );

              }

          };
          maya.clear_selection = function()
          {
            picker_util.clear_selection();
            PanZoom.selection_names = [];
          }

           $(this.svg_doc).click(function(evt)
           {
               svg_element = svg_doc.getElementsByTagName("svg")[0];
               if (evt.target == svg_element && PanZoom.is_active == false && !evt.shiftKey)
               {
                   maya.mel("select -cl");
               }
           });

           $(this.svg_doc).find(".control").click(function (evt)
           {
               if (!evt.target.parentNode.classList.contains("disabled") && PanZoom.is_active == false)
               {
                   cmd = picker_util.select_cmd_from_event(evt);

                   cmd += " " +  window.asset_namespace + ":" + picker_util.get_control_name(evt.target.parentNode);
                   maya.mel(cmd);

                   if (evt.target.parentNode.classList.contains("rotate")) {
                       maya.mel("setToolTo $gRotate");
                   }
                   else if (evt.target.parentNode.classList.contains("translate")) {
                       maya.mel("setToolTo $gMove");
                   }
               }
           });
           
            
           //help to debug if control do not exist mark it visually
           $(this.svg_doc).find(".control").each
            (
              function (index, element)
              {
                  if (window.document.getElementById('error_picker').style.visibility == 'visible') { return; };
                  var exists = false;
                  for (var i = 0; i < window.asset_controls_list.length; i++)
                  {
                      var control_name = picker_util.get_control_name(element);
                      if (window.asset_controls_list[i] == control_name)
                      {
                          exists = true;
                          break;
                      }
                  }

                  if (!exists)
                  {
                      element.classList.add("error");
                      var error_msg = "Couldnt find control'" + control_name + "'";
                      $.notify(error_msg, { className: "error", position: "bottom" });
                  }
                 
                    
              }
            );
           var that = this;
           $(this.svg_doc).find(".control").dblclick(function (evt)
           {
               //select control group using double click
               // using our naming convention
               // first we try to extract group using naming template
               // {side}_{group}_{control_name}_control
               // L_arm_ik_1_control to L_arm_*_control
               // if this fails
               // we can just remove digits and replace it using wildcards
               // e.g L_arm_ik_1_control to L_arm_ik_*_control

               if (!evt.target.parentNode.classList.contains("disabled") && PanZoom.is_active == false)
               {
                   var have_group = evt.target.parentNode.hasAttribute("group");
                   var group_name = "";
                   if (have_group == true)
                   {
                       group_name = evt.target.parentNode.getAttribute("group");
                   }
                   cmd = picker_util.select_cmd_from_event(evt);
                   var control_name_query = picker_util.get_control_name(evt.target.parentNode);
                   //change all numbers to wildcard
                   var name_elements = control_name_query.split("_");
                   if( name_elements.length >= 4)
                   {
                       control_name_query = name_elements[0] + "_" + name_elements[1] + "(.*)" + "_" + name_elements[name_elements.length - 1];
                   }
                   else
                   {
                       control_name_query = control_name_query.replace(/\d+/g, "(.*)");
                   }

                   var control_list = [];
                   $(that.svg_doc).find(".control").not("disabled").not("hidden").each(function (index, element) {
           
                       var control_name = picker_util.get_control_name(element);
                       if (!have_group)
                       {
                          
                           if (RegExp(control_name_query).test(control_name) == true) {

                               
                               control_list.push(maya.add_asset_namespace(control_name));

                           }
                       }
                       else
                       {
                           if (element.hasAttribute("group") && element.getAttribute("group") == group_name)
                           {
                               control_list.push(maya.add_asset_namespace(control_name));
                           }
                       }
                      

                   });
                   if (control_list.length > 0)
                   {
                       for (var i = 0; i < control_list.length; i++)
                       {
                           cmd += " " + control_list[i];
                       }

                       maya.mel(cmd);

                       if (evt.target.parentNode.classList.contains("rotate")) {
                           maya.mel("setToolTo $gRotate");
                       }
                       else if (evt.target.parentNode.classList.contains("translate")) {
                           maya.mel("setToolTo $gMove");
                       }
                   }
               }
           });
          //PanZoom must be created alredy
          //top_panel_name hardcoded
          top_panel = document.getElementById("top_panel")
          if (top_panel != null)
          {
              if(top_panel.getSVGDocument() == null)
              {
                  top_panel.addEventListener("load", this.install_top_panel_callbacks);
              }
              else
              {
                  this.install_top_panel_callbacks();
              }
           
          }
          //avatar_panel_name hardcoded
          avatar_panel = document.getElementById("avatar_panel");
          if(avatar_panel != null)
          {
              if (avatar_panel.getSVGDocument() == null) {
                  avatar_panel.addEventListener("load", this.install_avatar_panel_callbacks);
              }
              else {
                  this.install_avatar_panel_callbacks();
              }
          }
           
          if (window.picker_face_camera == true) {

              var avatar_image = document.getElementById("avatar_image")
              avatar_image.classList.add("picker_cam");

              $(avatar_image).click(function (evt) {
                  if (PanZoom.is_active == false && !evt.shiftKey) {
                      picker_util.open_face_cam();
                  }
              });
          }
          //empty space context_menu
          var that = this;
          this.contextmenu("svg", false, {svg_doc: svg_doc}, function(evt, callback_data, posX, posY)
          {
              svg_element = svg_doc.getElementsByTagName("svg")[0];
              if(evt.target == svg_element && PanZoom.is_active == false)
              {
                  maya.call_contextmenu(posX, posY,
                  [
                    ["Pick Body", "picker_util.pick_layer_controls('body')"],
                    ["Pick Face", "picker_util.pick_layer_controls('face')"],
                    ["Pick All", "picker_util.pick_all_controls()"],
                    ["Zero Selected", "picker_util.reset_selected_controls()"],
                    ["Zero All", "maya.python('import wizart.anim_utils as anim_utils;anim_utils.resetControls(\""+ window.asset_namespace+ ":\")');"]
                  ]
                  );
              }
          });



          this.install_common_context_menu();

          maya.call_sync_selection();
    }
};
