maya.global_attribute_change_callbacks = [];

maya.track_attributes = function (attributes_list)
{
    maya.call_python_callback(window.track_attributes_cid, attributes_list);
}
maya.attribute_change = function (attribute_name, attribute_value)
{
  for(var i = 0; i < maya.global_attribute_change_callbacks.length; i++)
  {
    maya.global_attribute_change_callbacks[i](attribute_name, attribute_value);
  }
}

maya.add_attribute_change_callback = function( change_callback )
{
  maya.global_attribute_change_callbacks.push(change_callback);
};

maya.node_selected = function(node_name)
{
    console.log("maya.node_selected", node_name);
}
maya.clear_selection = function()
{
  console.log("maya.clear_selection");
}

maya.update_selection = function(new_selection)
{
    console.log("maya.update_selection");
}
maya.call_contextmenu = function(posX, posY, menu_items)
{
    maya.call_python_callback(window.popup_menu_cid, [posX, posY, menu_items]);
}
maya.call_key_event = function(key_code, shift, control, alt)
{
  maya.call_python_callback(window.key_event_cid, [key_code, shift, control, alt]);
}

maya.call_sync_selection = function()
{
  maya.call_python_callback(window.sync_selection_cid, []);
}

maya.call_open_face_cam = function(face_controls)
{
  maya.call_python_callback(window.open_face_cam_cid, [face_controls]);
}

maya.add_asset_namespace = function(name)
{
  return window.asset_namespace + ":" + name;
}

maya.extract_namespace = function(name)
{
  var name_elements = name.split(':');
  //remove name
  name_elements.pop();
  return name_elements.join(":")
}
maya.remove_namespace = function(name)
{
    var name_elements = name.split(":");
    return name_elements[name_elements.length -1];
}
